---
generated_at: 2026-01-21 16:46:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-Add/Edit Rule

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00007.sql` (行1-578)
- E-02: `src/plsql/pkg/qa_unit_tests_pkg.sql` (行1388-1433)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (行9)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page IDは7である | E-01（行15: p_id=>7） | ○ |
| C-02 | エイリアスはADD-EDIT-RULEである | E-01（行17: p_alias=>'ADD-EDIT-RULE'） | ○ |
| C-03 | Protection LevelはCである | E-01（行22: p_protection_level=>'C'） | ○ |
| C-04 | モーダルダイアログである | E-01（行18: p_page_mode=>'MODAL'） | ○ |
| C-05 | ストレッチダイアログである | E-01（行21: p_page_template_options=>'#DEFAULT#:ui-dialog--stretch'） | ○ |
| C-06 | データソースはQA_RULES_P0007_Vビュー | E-01（行44: p_query_table=>'QA_RULES_P0007_V'） | ○ |
| C-07 | P7_QARU_IDはプライマリキー | E-01（行156: p_is_primary_key=>true） | ○ |
| C-08 | P7_QARU_RULE_NUMBERは必須 | E-01（行171: p_is_required=>true） | ○ |
| C-09 | P7_QARU_RULE_NUMBERは編集時読み取り専用 | E-01（行180-181: p_read_only_when=>'P7_QARU_ID'） | ○ |
| C-10 | P7_QARU_CATEGORYはラジオグループ | E-01（行247: p_display_as=>'NATIVE_RADIOGROUP'） | ○ |
| C-11 | P7_QARU_CATEGORYはRULE_CATEGORIES_LOVを使用 | E-01（行248: p_named_lov=>'RULE_CATEGORIES_LOV'） | ○ |
| C-12 | P7_QARU_IS_ACTIVEのデフォルトは1（Yes） | E-01（行329: p_item_default=>'1'） | ○ |
| C-13 | P7_QARU_IS_ACTIVEはYes/No形式 | E-01（行333: p_display_as=>'NATIVE_YES_NO'） | ○ |
| C-14 | P7_QARU_SQLは45行のテキストエリア | E-01（行376: p_cHeight=>45） | ○ |
| C-15 | P7_QARU_OBJECT_TYPESにクイックピックがある | E-01（行432-445: p_show_quick_picks=>'Y'） | ○ |
| C-16 | Object Typesの区切り文字説明がある | E-01（行427: p_inline_help_text=>'Use a colon (:)...） | ○ |
| C-17 | DELETEボタンにconfirm_messageがある | E-01（行112: p_confirm_message=>'Do you really want to delete this rule?'） | ○ |
| C-18 | DELETEボタンはP7_QARU_ID IS NOT NULL条件 | E-01（行114-115: p_button_condition=>'P7_QARU_ID'） | ○ |
| C-19 | SAVEボタンはP7_QARU_ID IS NOT NULL条件 | E-01（行130-131: p_button_condition=>'P7_QARU_ID'） | ○ |
| C-20 | CREATEボタンはP7_QARU_ID IS NULL条件 | E-01（行147-148: p_button_condition_type=>'ITEM_IS_NULL'） | ○ |
| C-21 | 削除可能チェックバリデーションがある | E-01（行446-458: Validate if rule can be deleted） | ○ |
| C-22 | f_has_rule_test_resultsを呼び出して削除可能チェック | E-01（行450-452: 'qa_unit_tests_pkg.f_has_rule_test_results'） | ○ |
| C-23 | ルール番号重複チェックバリデーションがある | E-01（行459-490: Validate if Rule already exists） | ○ |
| C-24 | ルール名重複チェックバリデーションがある | E-01（行491-522: Validate if Name already exists） | ○ |
| C-25 | Save Form ProcessはNATIVE_FORM_DML | E-01（行547: p_process_type=>'NATIVE_FORM_DML'） | ○ |
| C-26 | 成功メッセージは「Changes saved.」 | E-01（行554: p_process_success_message=>'Changes saved.'） | ○ |
| C-27 | Close DialogプロセスがNATIVE_CLOSE_WINDOW | E-01（行561: p_process_type=>'NATIVE_CLOSE_WINDOW'） | ○ |
| C-28 | f_has_rule_test_resultsでテスト結果有無を確認 | E-02（行1388-1433） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードと完全に整合している

## 6) レビュアーチェックリスト（最小）
- [ ] QA_RULES_P0007_Vビューが正しく定義されているか確認
- [ ] LOV（RULE_CATEGORIES_LOV、RULE_LAYERS_LOV、RULE_ERROR_LEVELS_LOV）が定義されているか確認
- [ ] ルール番号・名前の重複チェックロジックが正しいか確認
- [ ] 削除時のテスト結果チェックが正しく動作するか確認
- [ ] SQL Statementの入力内容に対するセキュリティ（SQLインジェクション対策）を確認
